%% Function to optimise the agreement between two sets of strain gauge coordinate 
% minimise average error between groups of points
% using TransFun transformation function
% 
% A MacLeod
% University of Bath, July 2015
%
% vals1 (hard coded into Trans_Err_2) are the points that vals2 (also hard 
% coded into Trans_Err_2) will be alligned to
% optvals are the 3 rotations and 3 translations that produce the best
% match
%
%%
%function Opt_Trans_rand(orig, trans)
vals1=input('enter the points to be alligned to: ');
vals2=input('enter the points to be alligned/transformed: ');
%
%x0=[0,0,0,0,0,0];
for p=1:1000
    x0=[randi([-314 314],1,1)/100,randi([-314 314],1,1)/100,randi([-314 314],1,1)/100,randi([-1800 1800],1,1),randi([-1800 1800],1,1),randi([-1800 1800],1,1),randi([6,18],1,1)/10,randi([6,18],1,1)/10,randi([6,18],1,1)/10];
    %x0=[0,0,2.5631,0,0,0];
    % x0=[3.1416   -2.9679   -3.0843 -163.0736  224.0678 -535.4394];
    % optimises for minimum error. Trans_Err_2 has a sinlge input - the
    % 6 transformation values. It has a sinlge output - the error between the
    % sets of points (TransFun just simply transforms the coordinates using a transformation matrix). 
    % The two sets of untransformed points are coded into the Trans_Err_2 script.
    %
    lb=[-2*pi,-2*pi,-2*pi,-1800,-1800,-1800, 0.6,0.6,0.6];
    ub=[2*pi,2*pi,2*pi,1800,1800,1800, 1.8,1.8,1.8];
    options.MaxIter=4200;
    options.TolX=1E-6;
    options.MaxFunEvals = 400;
    optvals=lsqnonlin(@Trans_Err_2_5pts_sc ,x0, lb,ub,options);
    %
    %disp('values of rotation and displacement that minimise error: ')
    %disp(optvals);
    %degrees=[optvals(1)*180/pi,optvals(2)*180/pi,optvals(3)*180/pi,optvals(4:6)];
    %disp('in degrees: ')
    %disp(degrees);
%
    alltests(p,:)=[optvals];
end
%disp('values of error at the optimised transformation: ')
%disp(transvals);
%% Create an error magnitude matrix from all of the values.
%
for p=1:1000
    trans=alltests(p,1:9);
    new=TransFun_sc(vals2,trans);
    %
    test=new-vals1;
    for i=1:5
        mags(p,i)=norm(test(i,:));
    end
    %alltests(p,8:14)=trans;
    %alltests(p,15:21)=[alltests(p,8)- alltests(p,1),alltests(p,9)- alltests(p,2),alltests(p,10)- alltests(p,3),alltests(p,11)- alltests(p,4),alltests(p,12)- alltests(p,5),alltests(p,13)- alltests(p,6),alltests(p,14)- alltests(p,7)];
end
%% Search for the minimum arror magnitude
index=1;
for p=1:1:1000
    sum=mags(p,1)+mags(p,2)+mags(p,3);
    mags(p,4)=sum;
    if mags(p,4)<mags(index,4)
        index=p;
    end
end
%
disp('the lowest absolute error magnitude for the coordinates is: ')
disp(mags(index,4))
trans=alltests(index,1:9)
%%
new=TransFun_sc(vals2, trans)
o=vals1;
plot3(o(:,1),o(:,2),o(:,3),'ro')
hold on
plot3(new(:,1),new(:,2),new(:,3),'go')
axis equal
disp('Red points = Points to align to')
disp('Green points = Aligned OpenSim points')
% %
% axislimits=[ -200,200,-200,200,0,600];
% axis(axislimits);
% xlabel('x');
% ylabel('y');
% zlabel('z');
%
%%
% plot3(trans(:,1),trans(:,2),trans(:,3),'go')
% hold on
% plot3(orig(:,1),orig(:,2),orig(:,3),'ro')
% axis equal
%%
%
clear x0
clear ub
clear test
clear sum
clear optvals
clear lb
clear i
clear index
clear ans
clear options
clear p
clear o
clear new
%clear vals1
%clear vals2